/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.preview;

import com.aptana.browser.WebBrowserViewer;
import com.aptana.core.util.PlatformUtil;
import com.aptana.preview.PreviewEditorInput;
import com.aptana.preview.internal.Messages;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class PreviewEditorPart
extends EditorPart
implements IReusableEditor,
IShowEditorInput {
    public static final String EDITOR_ID = "com.aptana.preview.editor";
    private WebBrowserViewer webBrowser;
    private Browser nativeBrowser;
    private int progressWorked;
    private String initialURL;
    private Image image;
    private boolean disposed;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
        this.showEditorInput();
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        super.dispose();
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        int style = 1;
        if (PlatformUtil.isLinux()) {
            this.nativeBrowser = new Browser(parent, style);
            this.nativeBrowser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    if (event.current == 0) {
                        IProgressMonitor progressMonitor = PreviewEditorPart.this.getStatusBarProgressMonitor();
                        progressMonitor.done();
                        progressMonitor.beginTask("", event.total);
                        PreviewEditorPart.this.progressWorked = 0;
                    }
                    if (PreviewEditorPart.this.progressWorked < event.current) {
                        PreviewEditorPart.this.getStatusBarProgressMonitor().worked(event.current - PreviewEditorPart.this.progressWorked);
                        PreviewEditorPart.this.progressWorked = event.current;
                    }
                }

                public void completed(ProgressEvent event) {
                    PreviewEditorPart.this.getStatusBarProgressMonitor().done();
                }
            });
            this.nativeBrowser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    PreviewEditorPart.this.setTitleToolTip(event.title);
                }
            });
            this.nativeBrowser.setUrl(this.initialURL);
        } else {
            this.webBrowser = this.createBrowser(parent, style);
            this.webBrowser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    if (event.current == 0) {
                        IProgressMonitor progressMonitor = PreviewEditorPart.this.getStatusBarProgressMonitor();
                        progressMonitor.done();
                        progressMonitor.beginTask("", event.total);
                        PreviewEditorPart.this.progressWorked = 0;
                    }
                    if (PreviewEditorPart.this.progressWorked < event.current) {
                        PreviewEditorPart.this.getStatusBarProgressMonitor().worked(event.current - PreviewEditorPart.this.progressWorked);
                        PreviewEditorPart.this.progressWorked = event.current;
                    }
                }

                public void completed(ProgressEvent event) {
                    PreviewEditorPart.this.getStatusBarProgressMonitor().done();
                }
            });
            this.webBrowser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    PreviewEditorPart.this.setTitleToolTip(event.title);
                }
            });
            this.webBrowser.setURL(this.initialURL);
        }
    }

    protected WebBrowserViewer createBrowser(Composite parent, int style) {
        return new WebBrowserViewer(parent, style);
    }

    public void setFocus() {
        if (this.webBrowser != null) {
            this.webBrowser.setFocus();
        } else if (this.nativeBrowser != null) {
            this.nativeBrowser.setFocus();
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.showEditorInput();
        this.firePropertyChange(258);
    }

    public void showEditorInput(IEditorInput editorInput) {
        this.setInput(editorInput);
    }

    private void showEditorInput() {
        PreviewEditorInput pei = this.getPreviewEditorInput();
        if (pei != null) {
            this.initialURL = null;
            URL url = pei.getURL();
            if (url != null) {
                this.initialURL = url.toExternalForm();
            }
            if (this.webBrowser != null) {
                this.webBrowser.setURL(this.initialURL);
            } else if (this.nativeBrowser != null) {
                this.nativeBrowser.setUrl(this.initialURL);
            }
            this.setPartName(this.getEditorInputName());
            this.setTitleToolTip(pei.getToolTipText());
            Image oldImage = this.image;
            ImageDescriptor id = pei.getImageDescriptor();
            this.image = id.createImage();
            this.setTitleImage(this.image);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
    }

    protected String getEditorInputName() {
        PreviewEditorInput pei = this.getPreviewEditorInput();
        if (pei != null) {
            return MessageFormat.format(Messages.PreviewEditorPart_Title, pei.getName());
        }
        return null;
    }

    private IProgressMonitor getStatusBarProgressMonitor() {
        IStatusLineManager statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        return statusLineManager.getProgressMonitor();
    }

    public boolean close() {
        final boolean[] result = new boolean[1];
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                result[0] = PreviewEditorPart.this.getEditorSite().getPage().closeEditor((IEditorPart)PreviewEditorPart.this, false);
            }
        });
        return result[0];
    }

    protected PreviewEditorInput getPreviewEditorInput() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof PreviewEditorInput) {
            return (PreviewEditorInput)input;
        }
        return null;
    }
}

